// Autor: Gustav Matula

#include <cstdio>
#include <cstring>

#include <vector>
#include <set>
#include <map>
#include <iostream>

using namespace std;
typedef long long llint;
const llint inf = 1000000000000000000LL;

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define REP(i, n) FOR(i, 0, n)

#define TRACE(x) cerr << #x << " = " << x << endl
#define _ << " _ " <<

const int MAXN = 101;
const int MAXX = 10001;

int N;
int x[MAXN];

int dp[MAXN][MAXN][MAXX]; // puno

int calc(int l, int r, int sum) {
  if (sum < 0) return 0;
  if (l == r) return sum == 0;
  if (l + 1 == r) return sum == x[l];

  int &ret = dp[l][r][sum];
  if (ret >= 0) return ret;

  ret = calc(l + 1, r, sum - x[l]);

  FOR(i, l + 1, r)
    ret |= calc(l + 1, i + 1, x[l]) && calc(i + 1, r, sum - x[l]);
      
  return ret;
}

void construct(int l, int r, int sum, int d) {
  if (l == r) return;
  if (l + 1 == r) {
    REP(i, d) putchar('*');
    printf("%d\n", x[l]);
    return;
  }

  if (calc(l + 1, r, sum - x[l])) {
    REP(i, d) putchar('*');
    printf("%d\n", x[l]);
    construct(l + 1, r, sum - x[l], d);
    return;
  }

  FOR(i, l + 1, r) {
    if (calc(l + 1, i + 1, x[l]) && calc(i + 1, r, sum - x[l])) {
      REP(i, d) putchar('*');
      printf("%d\n", x[l]);
      construct(l + 1, i + 1, x[l], d + 1);
      construct(i + 1, r, sum - x[l], d);
      return;
    }
  }
}

int main(void) 
{
  scanf("%d", &N);
  REP(i, N) scanf("%d", x + i);

  if (N == 1) {
    printf("%d\n", x[0]);
    exit(0);
  }

  memset(dp, -1, sizeof dp);
  if (!calc(1, N, x[0])) puts("nema rjesenja");
  else {
    printf("%d\n", x[0]);
    construct(1, N, x[0], 1);
  }

  return 0;
}
